'use client'

import React, { useState } from 'react'
import { MessageCircle, X, Send, User } from 'lucide-react'

const WhatsAppWidget = () => {
  const [isOpen, setIsOpen] = useState(false)
  const [message, setMessage] = useState('')

  const quickMessages = [
    "I need help with my application",
    "What documents do I need?",
    "How to check application status?",
    "Book an appointment",
    "Processing time information"
  ]

  const phoneNumber = "27815212524" // Support WhatsApp number (27 81 52125242)

  const sendMessage = (customMessage?: string) => {
    const messageText = customMessage || message
    const encodedMessage = encodeURIComponent(
      `Hello, I need assistance with consular services. ${messageText}`
    )
    const whatsappUrl = `https://wa.me/${phoneNumber}?text=${encodedMessage}`
    window.open(whatsappUrl, '_blank')
    setMessage('')
    setIsOpen(false)
  }

  return (
    <>
      {/* Floating Button */}
      <div className="fixed bottom-6 right-6 z-50">
        {!isOpen && (
          <button
            onClick={() => setIsOpen(true)}
            className="bg-green-500 hover:bg-green-600 text-white rounded-full p-4 shadow-lg transition-all duration-300 hover:scale-110 animate-pulse"
            title="Get WhatsApp Support"
          >
            <MessageCircle className="h-6 w-6" />
          </button>
        )}
      </div>

      {/* Chat Widget */}
      {isOpen && (
        <div className="fixed bottom-6 right-6 z-50 w-80 bg-white rounded-lg shadow-2xl border border-gray-200 overflow-hidden">
          {/* Header */}
          <div className="bg-green-500 text-white p-4 flex items-center justify-between">
            <div className="flex items-center space-x-3">
              <div className="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center">
                <User className="h-6 w-6" />
              </div>
              <div>
                <h3 className="font-semibold">WhatsApp Support</h3>
                <p className="text-green-100 text-sm">Consular Services Help</p>
              </div>
            </div>
            <button
              onClick={() => setIsOpen(false)}
              className="text-white/80 hover:text-white transition-colors"
            >
              <X className="h-5 w-5" />
            </button>
          </div>

          {/* Chat Content */}
          <div className="p-4 max-h-80 overflow-y-auto">
            {/* Welcome Message */}
            <div className="mb-4">
              <div className="bg-gray-100 rounded-lg p-3 text-sm">
                <p className="font-medium text-gray-800 mb-1">Welcome! 👋</p>
                <p className="text-gray-600">
                  We're here to help with your consular service needs. Choose a quick option below or type your message.
                </p>
              </div>
            </div>

            {/* Quick Message Buttons */}
            <div className="space-y-2 mb-4">
              <p className="text-sm font-medium text-gray-700">Quick Questions:</p>
              {quickMessages.map((msg, index) => (
                <button
                  key={index}
                  onClick={() => sendMessage(msg)}
                  className="w-full text-left p-2 text-sm bg-blue-50 hover:bg-blue-100 text-blue-700 rounded-lg transition-colors border border-blue-200"
                >
                  {msg}
                </button>
              ))}
            </div>

            {/* Office Hours Info */}
            <div className="bg-yellow-50 border border-yellow-200 rounded-lg p-3 mb-4">
              <p className="text-sm font-medium text-yellow-800 mb-1">📞 Office Hours</p>
              <p className="text-xs text-yellow-700">
                Mon-Fri: 9:00 AM - 5:00 PM<br />
                Sat: 9:00 AM - 1:00 PM<br />
                Emergency: 24/7 WhatsApp Support
              </p>
            </div>
          </div>

          {/* Message Input */}
          <div className="border-t border-gray-200 p-4">
            <div className="flex space-x-2">
              <input
                type="text"
                value={message}
                onChange={(e) => setMessage(e.target.value)}
                placeholder="Type your message..."
                className="flex-1 px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-transparent text-sm"
                onKeyPress={(e) => e.key === 'Enter' && sendMessage()}
              />
              <button
                onClick={() => sendMessage()}
                disabled={!message.trim()}
                className="bg-green-500 hover:bg-green-600 disabled:bg-gray-300 text-white p-2 rounded-lg transition-colors"
              >
                <Send className="h-4 w-4" />
              </button>
            </div>

            <div className="flex items-center justify-between mt-2">
              <p className="text-xs text-gray-500">
                Powered by WhatsApp
              </p>
              <div className="flex items-center space-x-1 text-green-600">
                <div className="w-2 h-2 bg-green-500 rounded-full animate-pulse"></div>
                <span className="text-xs">Online</span>
              </div>
            </div>
          </div>
        </div>
      )}

      {/* WhatsApp Business Info */}
      {isOpen && (
        <div className="fixed bottom-96 right-6 z-40 w-80 bg-green-50 border border-green-200 rounded-lg p-3 shadow-lg">
          <div className="flex items-center space-x-2 text-green-700">
            <svg className="h-4 w-4" fill="currentColor" viewBox="0 0 24 24">
              <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893A11.821 11.821 0 0020.885 3.309"/>
            </svg>
            <span className="text-sm font-medium">
              Official Consular Services WhatsApp
            </span>
          </div>
          <p className="text-xs text-green-600 mt-1">
            Secure • Verified • Government Authorized
          </p>
        </div>
      )}
    </>
  )
}

export default WhatsAppWidget
